{
 Author:       Craig Ward
 Copyright:    <>

 Date:         17/5/96

 Version:      1.0

 Overview:     Base for a Windows screen-saver.

 Notes:        Uses the following custom components:

                    [1] cwButton
                    [2] cwAbout
                    [3] cwListBox

*******************************************************************************}
program Delphiss;

uses
  SysUtils,
  Forms,
  dialogs,
  Config in 'CONFIG.PAS' {ScreenSaveDialog},
  Conini in 'CONINI.PAS',
  Enter in 'ENTER.PAS' {PassEnterDlg},
  Passw in 'PASSW.PAS' {PassDlg},
  Scrn in 'SCRN.PAS' {ScrnSaveForm},
  Remcoll in 'REMCOLL.PAS' {RemCollectDlg},
  Addcoll in 'ADDCOLL.PAS' {AddCollectDlg},
  Setcoll in 'SETCOLL.PAS' {SetCollectDlg};

{$R *.RES}
{$R EXTENDED.RES}
{$D SCRNSAVE Delphi SS}

begin
 Application.Title := 'Screen Saver.Delphi_SS';
  if hPrevInst <> 0 then {don't duplicate copies to run}
  application.terminate
 else
  begin
   if (pos('c',ParamStr(1)) <> 0) or (pos('C',ParamStr(1)) <> 0) then
    begin {configuration dialog}
     ScreenSaveDialog := TScreenSaveDialog.create(application);
     try
      {note: technically, a screen-saver configuration dialog should be shown
       modally by Control-Panel. At present, this screen-saver is not behaving
       in such a way.}
      ScreenSaveDialog.showModal;
     finally
      ScreenSaveDialog.free;
     end;
    end
   else
    begin {screen-saver}
     Application.CreateForm(TScrnSaveForm, ScrnSaveForm);
     Application.run;
    end;
  end;
end.
